package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateResponseHeadersPolicyRequest(
    responseHeadersPolicyConfig: zio.aws.cloudfront.model.ResponseHeadersPolicyConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyRequest = {
    import CreateResponseHeadersPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyRequest
      .builder()
      .responseHeadersPolicyConfig(responseHeadersPolicyConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateResponseHeadersPolicyRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateResponseHeadersPolicyRequest
      .wrap(buildAwsValue())
}
object CreateResponseHeadersPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CreateResponseHeadersPolicyRequest =
      zio.aws.cloudfront.model.CreateResponseHeadersPolicyRequest(
        responseHeadersPolicyConfig.asEditable
      )
    def responseHeadersPolicyConfig
        : zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly
    def getResponseHeadersPolicyConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly
    ] = ZIO.succeed(responseHeadersPolicyConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyRequest
  ) extends zio.aws.cloudfront.model.CreateResponseHeadersPolicyRequest.ReadOnly {
    override val responseHeadersPolicyConfig
        : zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly =
      zio.aws.cloudfront.model.ResponseHeadersPolicyConfig
        .wrap(impl.responseHeadersPolicyConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyRequest
  ): zio.aws.cloudfront.model.CreateResponseHeadersPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
