package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class StatusCodes(quantity: Integer, items: Iterable[Integer]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.StatusCodes = {
    import StatusCodes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.StatusCodes
      .builder()
      .quantity(quantity: java.lang.Integer)
      .items(items.map { item =>
        item: java.lang.Integer
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.StatusCodes.ReadOnly =
    zio.aws.cloudfront.model.StatusCodes.wrap(buildAwsValue())
}
object StatusCodes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.StatusCodes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.StatusCodes =
      zio.aws.cloudfront.model.StatusCodes(quantity, items)
    def quantity: Integer
    def items: List[Integer]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, Nothing, List[Integer]] = ZIO.succeed(items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.StatusCodes
  ) extends zio.aws.cloudfront.model.StatusCodes.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items: List[Integer] = impl
      .items()
      .asScala
      .map { item =>
        item: Integer
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.StatusCodes
  ): zio.aws.cloudfront.model.StatusCodes.ReadOnly = new Wrapper(impl)
}
