package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResponseHeadersPolicyStrictTransportSecurity(
    `override`: Boolean,
    includeSubdomains: Optional[Boolean] = Optional.Absent,
    preload: Optional[Boolean] = Optional.Absent,
    accessControlMaxAgeSec: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity = {
    import ResponseHeadersPolicyStrictTransportSecurity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity
      .builder()
      .`override`(`override`: java.lang.Boolean)
      .optionallyWith(includeSubdomains.map(value => value: java.lang.Boolean))(
        _.includeSubdomains
      )
      .optionallyWith(preload.map(value => value: java.lang.Boolean))(_.preload)
      .accessControlMaxAgeSec(accessControlMaxAgeSec: java.lang.Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity.ReadOnly =
    zio.aws.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity
      .wrap(buildAwsValue())
}
object ResponseHeadersPolicyStrictTransportSecurity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity =
      zio.aws.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity(
        `override`,
        includeSubdomains.map(value => value),
        preload.map(value => value),
        accessControlMaxAgeSec
      )
    def `override`: Boolean
    def includeSubdomains: Optional[Boolean]
    def preload: Optional[Boolean]
    def accessControlMaxAgeSec: Integer
    def getOverride: ZIO[Any, Nothing, Boolean] = ZIO.succeed(`override`)
    def getIncludeSubdomains: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeSubdomains", includeSubdomains)
    def getPreload: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("preload", preload)
    def getAccessControlMaxAgeSec: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(accessControlMaxAgeSec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity
  ) extends zio.aws.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity.ReadOnly {
    override val `override`: Boolean = impl.`override`(): Boolean
    override val includeSubdomains: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeSubdomains())
      .map(value => value: Boolean)
    override val preload: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.preload())
      .map(value => value: Boolean)
    override val accessControlMaxAgeSec: Integer =
      impl.accessControlMaxAgeSec(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity
  ): zio.aws.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity.ReadOnly =
    new Wrapper(impl)
}
