package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePublicKeyResponse(
    publicKey: Optional[zio.aws.cloudfront.model.PublicKey] = Optional.Absent,
    location: Optional[String] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse = {
    import CreatePublicKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse
      .builder()
      .optionallyWith(publicKey.map(value => value.buildAwsValue()))(
        _.publicKey
      )
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreatePublicKeyResponse.ReadOnly =
    zio.aws.cloudfront.model.CreatePublicKeyResponse.wrap(buildAwsValue())
}
object CreatePublicKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreatePublicKeyResponse =
      zio.aws.cloudfront.model.CreatePublicKeyResponse(
        publicKey.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def publicKey: Optional[zio.aws.cloudfront.model.PublicKey.ReadOnly]
    def location: Optional[String]
    def eTag: Optional[String]
    def getPublicKey
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.PublicKey.ReadOnly] =
      AwsError.unwrapOptionField("publicKey", publicKey)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse
  ) extends zio.aws.cloudfront.model.CreatePublicKeyResponse.ReadOnly {
    override val publicKey
        : Optional[zio.aws.cloudfront.model.PublicKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicKey())
        .map(value => zio.aws.cloudfront.model.PublicKey.wrap(value))
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse
  ): zio.aws.cloudfront.model.CreatePublicKeyResponse.ReadOnly = new Wrapper(
    impl
  )
}
