package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFieldLevelEncryptionProfileResponse(
    fieldLevelEncryptionProfile: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile
    ] = Optional.Absent,
    location: Optional[String] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse = {
    import CreateFieldLevelEncryptionProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse
      .builder()
      .optionallyWith(
        fieldLevelEncryptionProfile.map(value => value.buildAwsValue())
      )(_.fieldLevelEncryptionProfile)
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse
      .wrap(buildAwsValue())
}
object CreateFieldLevelEncryptionProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse =
      zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse(
        fieldLevelEncryptionProfile.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def fieldLevelEncryptionProfile: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile.ReadOnly
    ]
    def location: Optional[String]
    def eTag: Optional[String]
    def getFieldLevelEncryptionProfile: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fieldLevelEncryptionProfile",
      fieldLevelEncryptionProfile
    )
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse
  ) extends zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse.ReadOnly {
    override val fieldLevelEncryptionProfile: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldLevelEncryptionProfile())
      .map(value =>
        zio.aws.cloudfront.model.FieldLevelEncryptionProfile.wrap(value)
      )
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse
  ): zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse.ReadOnly =
    new Wrapper(impl)
}
