package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KinesisStreamConfig(roleARN: String, streamARN: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.KinesisStreamConfig = {
    import KinesisStreamConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.KinesisStreamConfig
      .builder()
      .roleARN(roleARN: java.lang.String)
      .streamARN(streamARN: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.KinesisStreamConfig.ReadOnly =
    zio.aws.cloudfront.model.KinesisStreamConfig.wrap(buildAwsValue())
}
object KinesisStreamConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.KinesisStreamConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.KinesisStreamConfig =
      zio.aws.cloudfront.model.KinesisStreamConfig(roleARN, streamARN)
    def roleARN: String
    def streamARN: String
    def getRoleARN: ZIO[Any, Nothing, String] = ZIO.succeed(roleARN)
    def getStreamARN: ZIO[Any, Nothing, String] = ZIO.succeed(streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.KinesisStreamConfig
  ) extends zio.aws.cloudfront.model.KinesisStreamConfig.ReadOnly {
    override val roleARN: String = impl.roleARN(): String
    override val streamARN: String = impl.streamARN(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.KinesisStreamConfig
  ): zio.aws.cloudfront.model.KinesisStreamConfig.ReadOnly = new Wrapper(impl)
}
