package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StreamingDistributionConfig(
    callerReference: String,
    s3Origin: zio.aws.cloudfront.model.S3Origin,
    aliases: Option[zio.aws.cloudfront.model.Aliases] = None,
    comment: String,
    logging: Option[zio.aws.cloudfront.model.StreamingLoggingConfig] = None,
    trustedSigners: zio.aws.cloudfront.model.TrustedSigners,
    priceClass: Option[zio.aws.cloudfront.model.PriceClass] = None,
    enabled: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfig = {
    import StreamingDistributionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfig
      .builder()
      .callerReference(callerReference: java.lang.String)
      .s3Origin(s3Origin.buildAwsValue())
      .optionallyWith(aliases.map(value => value.buildAwsValue()))(_.aliases)
      .comment(comment: java.lang.String)
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .trustedSigners(trustedSigners.buildAwsValue())
      .optionallyWith(priceClass.map(value => value.unwrap))(_.priceClass)
      .enabled(enabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly =
    zio.aws.cloudfront.model.StreamingDistributionConfig.wrap(buildAwsValue())
}
object StreamingDistributionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.StreamingDistributionConfig =
      zio.aws.cloudfront.model.StreamingDistributionConfig(
        callerReference,
        s3Origin.asEditable,
        aliases.map(value => value.asEditable),
        comment,
        logging.map(value => value.asEditable),
        trustedSigners.asEditable,
        priceClass.map(value => value),
        enabled
      )
    def callerReference: String
    def s3Origin: zio.aws.cloudfront.model.S3Origin.ReadOnly
    def aliases: Option[zio.aws.cloudfront.model.Aliases.ReadOnly]
    def comment: String
    def logging
        : Option[zio.aws.cloudfront.model.StreamingLoggingConfig.ReadOnly]
    def trustedSigners: zio.aws.cloudfront.model.TrustedSigners.ReadOnly
    def priceClass: Option[zio.aws.cloudfront.model.PriceClass]
    def enabled: Boolean
    def getCallerReference: ZIO[Any, Nothing, String] =
      ZIO.succeed(callerReference)
    def getS3Origin
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.S3Origin.ReadOnly] =
      ZIO.succeed(s3Origin)
    def getAliases
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Aliases.ReadOnly] =
      AwsError.unwrapOptionField("aliases", aliases)
    def getComment: ZIO[Any, Nothing, String] = ZIO.succeed(comment)
    def getLogging: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.StreamingLoggingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("logging", logging)
    def getTrustedSigners
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.TrustedSigners.ReadOnly] =
      ZIO.succeed(trustedSigners)
    def getPriceClass: ZIO[Any, AwsError, zio.aws.cloudfront.model.PriceClass] =
      AwsError.unwrapOptionField("priceClass", priceClass)
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfig
  ) extends zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly {
    override val callerReference: String = impl.callerReference(): String
    override val s3Origin: zio.aws.cloudfront.model.S3Origin.ReadOnly =
      zio.aws.cloudfront.model.S3Origin.wrap(impl.s3Origin())
    override val aliases: Option[zio.aws.cloudfront.model.Aliases.ReadOnly] =
      scala
        .Option(impl.aliases())
        .map(value => zio.aws.cloudfront.model.Aliases.wrap(value))
    override val comment: String = impl.comment(): String
    override val logging
        : Option[zio.aws.cloudfront.model.StreamingLoggingConfig.ReadOnly] =
      scala
        .Option(impl.logging())
        .map(value =>
          zio.aws.cloudfront.model.StreamingLoggingConfig.wrap(value)
        )
    override val trustedSigners
        : zio.aws.cloudfront.model.TrustedSigners.ReadOnly =
      zio.aws.cloudfront.model.TrustedSigners.wrap(impl.trustedSigners())
    override val priceClass: Option[zio.aws.cloudfront.model.PriceClass] = scala
      .Option(impl.priceClass())
      .map(value => zio.aws.cloudfront.model.PriceClass.wrap(value))
    override val enabled: Boolean = impl.enabled(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfig
  ): zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly =
    new Wrapper(impl)
}
