package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetPublicKeyConfigResponse(
    publicKeyConfig: Option[zio.aws.cloudfront.model.PublicKeyConfig] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse = {
    import GetPublicKeyConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse
      .builder()
      .optionallyWith(publicKeyConfig.map(value => value.buildAwsValue()))(
        _.publicKeyConfig
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.GetPublicKeyConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.GetPublicKeyConfigResponse.wrap(buildAwsValue())
}
object GetPublicKeyConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetPublicKeyConfigResponse =
      zio.aws.cloudfront.model.GetPublicKeyConfigResponse(
        publicKeyConfig.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def publicKeyConfig
        : Option[zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly]
    def eTag: Option[String]
    def getPublicKeyConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly
    ] = AwsError.unwrapOptionField("publicKeyConfig", publicKeyConfig)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse
  ) extends zio.aws.cloudfront.model.GetPublicKeyConfigResponse.ReadOnly {
    override val publicKeyConfig
        : Option[zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly] = scala
      .Option(impl.publicKeyConfig())
      .map(value => zio.aws.cloudfront.model.PublicKeyConfig.wrap(value))
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse
  ): zio.aws.cloudfront.model.GetPublicKeyConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
