package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDistributionResponse(
    distribution: Option[zio.aws.cloudfront.model.Distribution] = None,
    location: Option[String] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse = {
    import CreateDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse
      .builder()
      .optionallyWith(distribution.map(value => value.buildAwsValue()))(
        _.distribution
      )
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreateDistributionResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateDistributionResponse.wrap(buildAwsValue())
}
object CreateDistributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateDistributionResponse =
      zio.aws.cloudfront.model.CreateDistributionResponse(
        distribution.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def distribution: Option[zio.aws.cloudfront.model.Distribution.ReadOnly]
    def location: Option[String]
    def eTag: Option[String]
    def getDistribution
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Distribution.ReadOnly] =
      AwsError.unwrapOptionField("distribution", distribution)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse
  ) extends zio.aws.cloudfront.model.CreateDistributionResponse.ReadOnly {
    override val distribution
        : Option[zio.aws.cloudfront.model.Distribution.ReadOnly] = scala
      .Option(impl.distribution())
      .map(value => zio.aws.cloudfront.model.Distribution.wrap(value))
    override val location: Option[String] =
      scala.Option(impl.location()).map(value => value: String)
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse
  ): zio.aws.cloudfront.model.CreateDistributionResponse.ReadOnly = new Wrapper(
    impl
  )
}
