package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetResponseHeadersPolicyResponse(
    responseHeadersPolicy: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicy
    ] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyResponse = {
    import GetResponseHeadersPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyResponse
      .builder()
      .optionallyWith(
        responseHeadersPolicy.map(value => value.buildAwsValue())
      )(_.responseHeadersPolicy)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse.ReadOnly =
    zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse
      .wrap(buildAwsValue())
}
object GetResponseHeadersPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse =
      zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse(
        responseHeadersPolicy.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def responseHeadersPolicy
        : Option[zio.aws.cloudfront.model.ResponseHeadersPolicy.ReadOnly]
    def eTag: Option[String]
    def getResponseHeadersPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicy.ReadOnly
    ] =
      AwsError.unwrapOptionField("responseHeadersPolicy", responseHeadersPolicy)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyResponse
  ) extends zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse.ReadOnly {
    override val responseHeadersPolicy
        : Option[zio.aws.cloudfront.model.ResponseHeadersPolicy.ReadOnly] =
      scala
        .Option(impl.responseHeadersPolicy())
        .map(value =>
          zio.aws.cloudfront.model.ResponseHeadersPolicy.wrap(value)
        )
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyResponse
  ): zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
