package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetCloudFrontOriginAccessIdentityConfigResponse(
    cloudFrontOriginAccessIdentityConfig: Option[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig
    ] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse = {
    import GetCloudFrontOriginAccessIdentityConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse
      .builder()
      .optionallyWith(
        cloudFrontOriginAccessIdentityConfig.map(value => value.buildAwsValue())
      )(_.cloudFrontOriginAccessIdentityConfig)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse
      .wrap(buildAwsValue())
}
object GetCloudFrontOriginAccessIdentityConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse =
      zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse(
        cloudFrontOriginAccessIdentityConfig.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def cloudFrontOriginAccessIdentityConfig: Option[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly
    ]
    def eTag: Option[String]
    def getCloudFrontOriginAccessIdentityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudFrontOriginAccessIdentityConfig",
      cloudFrontOriginAccessIdentityConfig
    )
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse
  ) extends zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse.ReadOnly {
    override val cloudFrontOriginAccessIdentityConfig: Option[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly
    ] = scala
      .Option(impl.cloudFrontOriginAccessIdentityConfig())
      .map(value =>
        zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig
          .wrap(value)
      )
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse
  ): zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse.ReadOnly =
    new Wrapper(impl)
}
