package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetCachePolicyConfigResponse(
    cachePolicyConfig: Option[zio.aws.cloudfront.model.CachePolicyConfig] =
      None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigResponse = {
    import GetCachePolicyConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigResponse
      .builder()
      .optionallyWith(cachePolicyConfig.map(value => value.buildAwsValue()))(
        _.cachePolicyConfig
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetCachePolicyConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.GetCachePolicyConfigResponse.wrap(buildAwsValue())
}
object GetCachePolicyConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetCachePolicyConfigResponse =
      zio.aws.cloudfront.model.GetCachePolicyConfigResponse(
        cachePolicyConfig.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def cachePolicyConfig
        : Option[zio.aws.cloudfront.model.CachePolicyConfig.ReadOnly]
    def eTag: Option[String]
    def getCachePolicyConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.CachePolicyConfig.ReadOnly
    ] = AwsError.unwrapOptionField("cachePolicyConfig", cachePolicyConfig)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigResponse
  ) extends zio.aws.cloudfront.model.GetCachePolicyConfigResponse.ReadOnly {
    override val cachePolicyConfig
        : Option[zio.aws.cloudfront.model.CachePolicyConfig.ReadOnly] = scala
      .Option(impl.cachePolicyConfig())
      .map(value => zio.aws.cloudfront.model.CachePolicyConfig.wrap(value))
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigResponse
  ): zio.aws.cloudfront.model.GetCachePolicyConfigResponse.ReadOnly =
    new Wrapper(impl)
}
