package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class CloudFrontOriginAccessIdentityList(
    marker: String,
    nextMarker: Option[String] = None,
    maxItems: Integer,
    isTruncated: Boolean,
    quantity: Integer,
    items: Option[
      Iterable[zio.aws.cloudfront.model.CloudFrontOriginAccessIdentitySummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityList = {
    import CloudFrontOriginAccessIdentityList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityList
      .builder()
      .marker(marker: java.lang.String)
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .maxItems(maxItems: java.lang.Integer)
      .isTruncated(isTruncated: java.lang.Boolean)
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityList.ReadOnly =
    zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityList
      .wrap(buildAwsValue())
}
object CloudFrontOriginAccessIdentityList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityList =
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityList(
        marker,
        nextMarker.map(value => value),
        maxItems,
        isTruncated,
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: String
    def nextMarker: Option[String]
    def maxItems: Integer
    def isTruncated: Boolean
    def quantity: Integer
    def items: Option[List[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentitySummary.ReadOnly
    ]]
    def getMarker: ZIO[Any, Nothing, String] = ZIO.succeed(marker)
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getMaxItems: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxItems)
    def getIsTruncated: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isTruncated)
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentitySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityList
  ) extends zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityList.ReadOnly {
    override val marker: String = impl.marker(): String
    override val nextMarker: Option[String] =
      scala.Option(impl.nextMarker()).map(value => value: String)
    override val maxItems: Integer = impl.maxItems(): Integer
    override val isTruncated: Boolean = impl.isTruncated(): Boolean
    override val quantity: Integer = impl.quantity(): Integer
    override val items: Option[List[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentitySummary.ReadOnly
    ]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.CloudFrontOriginAccessIdentitySummary
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityList
  ): zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityList.ReadOnly =
    new Wrapper(impl)
}
