package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class KeyPairIds(
    quantity: Integer,
    items: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.KeyPairIds = {
    import KeyPairIds.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.KeyPairIds
      .builder()
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.KeyPairIds.ReadOnly =
    zio.aws.cloudfront.model.KeyPairIds.wrap(buildAwsValue())
}
object KeyPairIds {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.KeyPairIds
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.KeyPairIds =
      zio.aws.cloudfront.model.KeyPairIds(quantity, items.map(value => value))
    def quantity: Integer
    def items: Option[List[String]]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.KeyPairIds
  ) extends zio.aws.cloudfront.model.KeyPairIds.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items: Option[List[String]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.KeyPairIds
  ): zio.aws.cloudfront.model.KeyPairIds.ReadOnly = new Wrapper(impl)
}
