package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait GeoRestrictionType {
  def unwrap
      : software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType
}
object GeoRestrictionType {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType
  ): zio.aws.cloudfront.model.GeoRestrictionType = value match {
    case software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType.BLACKLIST =>
      val r = blacklist
      r
    case software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType.WHITELIST =>
      val r = whitelist
      r
    case software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType.NONE =>
      val r = none
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.GeoRestrictionType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType =
      software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType.UNKNOWN_TO_SDK_VERSION
  }
  case object blacklist extends zio.aws.cloudfront.model.GeoRestrictionType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType =
      software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType.BLACKLIST
  }
  case object whitelist extends zio.aws.cloudfront.model.GeoRestrictionType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType =
      software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType.WHITELIST
  }
  case object none extends zio.aws.cloudfront.model.GeoRestrictionType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType =
      software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType.NONE
  }
}
