package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class FieldLevelEncryptionProfileList(
    nextMarker: Option[String] = None,
    maxItems: Integer,
    quantity: Integer,
    items: Option[
      Iterable[zio.aws.cloudfront.model.FieldLevelEncryptionProfileSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileList = {
    import FieldLevelEncryptionProfileList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileList
      .builder()
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .maxItems(maxItems: java.lang.Integer)
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.FieldLevelEncryptionProfileList.ReadOnly =
    zio.aws.cloudfront.model.FieldLevelEncryptionProfileList
      .wrap(buildAwsValue())
}
object FieldLevelEncryptionProfileList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.FieldLevelEncryptionProfileList =
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileList(
        nextMarker.map(value => value),
        maxItems,
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[String]
    def maxItems: Integer
    def quantity: Integer
    def items: Option[
      List[zio.aws.cloudfront.model.FieldLevelEncryptionProfileSummary.ReadOnly]
    ]
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getMaxItems: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxItems)
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileList
  ) extends zio.aws.cloudfront.model.FieldLevelEncryptionProfileList.ReadOnly {
    override val nextMarker: Option[String] =
      scala.Option(impl.nextMarker()).map(value => value: String)
    override val maxItems: Integer = impl.maxItems(): Integer
    override val quantity: Integer = impl.quantity(): Integer
    override val items: Option[
      List[zio.aws.cloudfront.model.FieldLevelEncryptionProfileSummary.ReadOnly]
    ] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.FieldLevelEncryptionProfileSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileList
  ): zio.aws.cloudfront.model.FieldLevelEncryptionProfileList.ReadOnly =
    new Wrapper(impl)
}
