package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDistributionRequest(
    distributionConfig: zio.aws.cloudfront.model.DistributionConfig,
    id: String,
    ifMatch: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest = {
    import UpdateDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest
      .builder()
      .distributionConfig(distributionConfig.buildAwsValue())
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.UpdateDistributionRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateDistributionRequest.wrap(buildAwsValue())
}
object UpdateDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateDistributionRequest =
      zio.aws.cloudfront.model.UpdateDistributionRequest(
        distributionConfig.asEditable,
        id,
        ifMatch.map(value => value)
      )
    def distributionConfig: zio.aws.cloudfront.model.DistributionConfig.ReadOnly
    def id: String
    def ifMatch: Option[String]
    def getDistributionConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.DistributionConfig.ReadOnly
    ] = ZIO.succeed(distributionConfig)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest
  ) extends zio.aws.cloudfront.model.UpdateDistributionRequest.ReadOnly {
    override val distributionConfig
        : zio.aws.cloudfront.model.DistributionConfig.ReadOnly =
      zio.aws.cloudfront.model.DistributionConfig
        .wrap(impl.distributionConfig())
    override val id: String = impl.id(): String
    override val ifMatch: Option[String] =
      scala.Option(impl.ifMatch()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest
  ): zio.aws.cloudfront.model.UpdateDistributionRequest.ReadOnly = new Wrapper(
    impl
  )
}
