package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateCachePolicyRequest(
    cachePolicyConfig: zio.aws.cloudfront.model.CachePolicyConfig,
    id: String,
    ifMatch: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyRequest = {
    import UpdateCachePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyRequest
      .builder()
      .cachePolicyConfig(cachePolicyConfig.buildAwsValue())
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.UpdateCachePolicyRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateCachePolicyRequest.wrap(buildAwsValue())
}
object UpdateCachePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateCachePolicyRequest =
      zio.aws.cloudfront.model.UpdateCachePolicyRequest(
        cachePolicyConfig.asEditable,
        id,
        ifMatch.map(value => value)
      )
    def cachePolicyConfig: zio.aws.cloudfront.model.CachePolicyConfig.ReadOnly
    def id: String
    def ifMatch: Option[String]
    def getCachePolicyConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.CachePolicyConfig.ReadOnly
    ] = ZIO.succeed(cachePolicyConfig)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyRequest
  ) extends zio.aws.cloudfront.model.UpdateCachePolicyRequest.ReadOnly {
    override val cachePolicyConfig
        : zio.aws.cloudfront.model.CachePolicyConfig.ReadOnly =
      zio.aws.cloudfront.model.CachePolicyConfig.wrap(impl.cachePolicyConfig())
    override val id: String = impl.id(): String
    override val ifMatch: Option[String] =
      scala.Option(impl.ifMatch()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyRequest
  ): zio.aws.cloudfront.model.UpdateCachePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
