package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResponseHeadersPolicyConfig(
    comment: Option[String] = None,
    name: String,
    corsConfig: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig
    ] = None,
    securityHeadersConfig: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig
    ] = None,
    customHeadersConfig: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyConfig = {
    import ResponseHeadersPolicyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyConfig
      .builder()
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .name(name: java.lang.String)
      .optionallyWith(corsConfig.map(value => value.buildAwsValue()))(
        _.corsConfig
      )
      .optionallyWith(
        securityHeadersConfig.map(value => value.buildAwsValue())
      )(_.securityHeadersConfig)
      .optionallyWith(customHeadersConfig.map(value => value.buildAwsValue()))(
        _.customHeadersConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly =
    zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.wrap(buildAwsValue())
}
object ResponseHeadersPolicyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ResponseHeadersPolicyConfig =
      zio.aws.cloudfront.model.ResponseHeadersPolicyConfig(
        comment.map(value => value),
        name,
        corsConfig.map(value => value.asEditable),
        securityHeadersConfig.map(value => value.asEditable),
        customHeadersConfig.map(value => value.asEditable)
      )
    def comment: Option[String]
    def name: String
    def corsConfig: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig.ReadOnly
    ]
    def securityHeadersConfig: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig.ReadOnly
    ]
    def customHeadersConfig: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig.ReadOnly
    ]
    def getComment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comment", comment)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getCorsConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig.ReadOnly
    ] = AwsError.unwrapOptionField("corsConfig", corsConfig)
    def getSecurityHeadersConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig.ReadOnly
    ] =
      AwsError.unwrapOptionField("securityHeadersConfig", securityHeadersConfig)
    def getCustomHeadersConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig.ReadOnly
    ] = AwsError.unwrapOptionField("customHeadersConfig", customHeadersConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyConfig
  ) extends zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly {
    override val comment: Option[String] =
      scala.Option(impl.comment()).map(value => value: String)
    override val name: String = impl.name(): String
    override val corsConfig: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig.ReadOnly
    ] = scala
      .Option(impl.corsConfig())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig.wrap(value)
      )
    override val securityHeadersConfig: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig.ReadOnly
    ] = scala
      .Option(impl.securityHeadersConfig())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig
          .wrap(value)
      )
    override val customHeadersConfig: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig.ReadOnly
    ] = scala
      .Option(impl.customHeadersConfig())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyConfig
  ): zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly =
    new Wrapper(impl)
}
