package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class RealtimeLogConfigs(
    maxItems: Integer,
    items: Option[Iterable[zio.aws.cloudfront.model.RealtimeLogConfig]] = None,
    isTruncated: Boolean,
    marker: String,
    nextMarker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigs = {
    import RealtimeLogConfigs.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigs
      .builder()
      .maxItems(maxItems: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .isTruncated(isTruncated: java.lang.Boolean)
      .marker(marker: java.lang.String)
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.RealtimeLogConfigs.ReadOnly =
    zio.aws.cloudfront.model.RealtimeLogConfigs.wrap(buildAwsValue())
}
object RealtimeLogConfigs {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigs
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.RealtimeLogConfigs =
      zio.aws.cloudfront.model.RealtimeLogConfigs(
        maxItems,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isTruncated,
        marker,
        nextMarker.map(value => value)
      )
    def maxItems: Integer
    def items: Option[List[zio.aws.cloudfront.model.RealtimeLogConfig.ReadOnly]]
    def isTruncated: Boolean
    def marker: String
    def nextMarker: Option[String]
    def getMaxItems: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxItems)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.RealtimeLogConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getIsTruncated: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isTruncated)
    def getMarker: ZIO[Any, Nothing, String] = ZIO.succeed(marker)
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigs
  ) extends zio.aws.cloudfront.model.RealtimeLogConfigs.ReadOnly {
    override val maxItems: Integer = impl.maxItems(): Integer
    override val items
        : Option[List[zio.aws.cloudfront.model.RealtimeLogConfig.ReadOnly]] =
      scala
        .Option(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.RealtimeLogConfig.wrap(item)
          }.toList
        )
    override val isTruncated: Boolean = impl.isTruncated(): Boolean
    override val marker: String = impl.marker(): String
    override val nextMarker: Option[String] =
      scala.Option(impl.nextMarker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigs
  ): zio.aws.cloudfront.model.RealtimeLogConfigs.ReadOnly = new Wrapper(impl)
}
