package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class Paths(
    quantity: Integer,
    items: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.Paths = {
    import Paths.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.Paths
      .builder()
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.Paths.ReadOnly =
    zio.aws.cloudfront.model.Paths.wrap(buildAwsValue())
}
object Paths {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.cloudfront.model.Paths] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.Paths =
      zio.aws.cloudfront.model.Paths(quantity, items.map(value => value))
    def quantity: Integer
    def items: Option[List[String]]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.Paths
  ) extends zio.aws.cloudfront.model.Paths.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items: Option[List[String]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.Paths
  ): zio.aws.cloudfront.model.Paths.ReadOnly = new Wrapper(impl)
}
