package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.FunctionBlob
import scala.jdk.CollectionConverters._
final case class GetFunctionResponse(
    functionCode: Option[FunctionBlob] = None,
    eTag: Option[String] = None,
    contentType: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetFunctionResponse = {
    import GetFunctionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetFunctionResponse
      .builder()
      .optionallyWith(
        functionCode.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.functionCode)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.GetFunctionResponse.ReadOnly =
    zio.aws.cloudfront.model.GetFunctionResponse.wrap(buildAwsValue())
}
object GetFunctionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetFunctionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetFunctionResponse =
      zio.aws.cloudfront.model.GetFunctionResponse(
        functionCode.map(value => value),
        eTag.map(value => value),
        contentType.map(value => value)
      )
    def functionCode: Option[FunctionBlob]
    def eTag: Option[String]
    def contentType: Option[String]
    def getFunctionCode: ZIO[Any, AwsError, FunctionBlob] =
      AwsError.unwrapOptionField("functionCode", functionCode)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getContentType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentType", contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetFunctionResponse
  ) extends zio.aws.cloudfront.model.GetFunctionResponse.ReadOnly {
    override val functionCode: Option[FunctionBlob] = scala
      .Option(impl.functionCode())
      .map(value =>
        zio.aws.cloudfront.model.primitives
          .FunctionBlob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
    override val contentType: Option[String] =
      scala.Option(impl.contentType()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetFunctionResponse
  ): zio.aws.cloudfront.model.GetFunctionResponse.ReadOnly = new Wrapper(impl)
}
