package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class FieldLevelEncryptionSummary(
    id: String,
    lastModifiedTime: Timestamp,
    comment: Option[String] = None,
    queryArgProfileConfig: Option[
      zio.aws.cloudfront.model.QueryArgProfileConfig
    ] = None,
    contentTypeProfileConfig: Option[
      zio.aws.cloudfront.model.ContentTypeProfileConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionSummary = {
    import FieldLevelEncryptionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionSummary
      .builder()
      .id(id: java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .optionallyWith(
        queryArgProfileConfig.map(value => value.buildAwsValue())
      )(_.queryArgProfileConfig)
      .optionallyWith(
        contentTypeProfileConfig.map(value => value.buildAwsValue())
      )(_.contentTypeProfileConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.FieldLevelEncryptionSummary.ReadOnly =
    zio.aws.cloudfront.model.FieldLevelEncryptionSummary.wrap(buildAwsValue())
}
object FieldLevelEncryptionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.FieldLevelEncryptionSummary =
      zio.aws.cloudfront.model.FieldLevelEncryptionSummary(
        id,
        lastModifiedTime,
        comment.map(value => value),
        queryArgProfileConfig.map(value => value.asEditable),
        contentTypeProfileConfig.map(value => value.asEditable)
      )
    def id: String
    def lastModifiedTime: Timestamp
    def comment: Option[String]
    def queryArgProfileConfig
        : Option[zio.aws.cloudfront.model.QueryArgProfileConfig.ReadOnly]
    def contentTypeProfileConfig
        : Option[zio.aws.cloudfront.model.ContentTypeProfileConfig.ReadOnly]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getComment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comment", comment)
    def getQueryArgProfileConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.QueryArgProfileConfig.ReadOnly
    ] =
      AwsError.unwrapOptionField("queryArgProfileConfig", queryArgProfileConfig)
    def getContentTypeProfileConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ContentTypeProfileConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "contentTypeProfileConfig",
      contentTypeProfileConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionSummary
  ) extends zio.aws.cloudfront.model.FieldLevelEncryptionSummary.ReadOnly {
    override val id: String = impl.id(): String
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val comment: Option[String] =
      scala.Option(impl.comment()).map(value => value: String)
    override val queryArgProfileConfig
        : Option[zio.aws.cloudfront.model.QueryArgProfileConfig.ReadOnly] =
      scala
        .Option(impl.queryArgProfileConfig())
        .map(value =>
          zio.aws.cloudfront.model.QueryArgProfileConfig.wrap(value)
        )
    override val contentTypeProfileConfig
        : Option[zio.aws.cloudfront.model.ContentTypeProfileConfig.ReadOnly] =
      scala
        .Option(impl.contentTypeProfileConfig())
        .map(value =>
          zio.aws.cloudfront.model.ContentTypeProfileConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionSummary
  ): zio.aws.cloudfront.model.FieldLevelEncryptionSummary.ReadOnly =
    new Wrapper(impl)
}
