package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class CustomOriginConfig(
    httpPort: Integer,
    httpsPort: Integer,
    originProtocolPolicy: zio.aws.cloudfront.model.OriginProtocolPolicy,
    originSslProtocols: Option[zio.aws.cloudfront.model.OriginSslProtocols] =
      None,
    originReadTimeout: Option[Integer] = None,
    originKeepaliveTimeout: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CustomOriginConfig = {
    import CustomOriginConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CustomOriginConfig
      .builder()
      .httpPort(httpPort: java.lang.Integer)
      .httpsPort(httpsPort: java.lang.Integer)
      .originProtocolPolicy(originProtocolPolicy.unwrap)
      .optionallyWith(originSslProtocols.map(value => value.buildAwsValue()))(
        _.originSslProtocols
      )
      .optionallyWith(originReadTimeout.map(value => value: java.lang.Integer))(
        _.originReadTimeout
      )
      .optionallyWith(
        originKeepaliveTimeout.map(value => value: java.lang.Integer)
      )(_.originKeepaliveTimeout)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CustomOriginConfig.ReadOnly =
    zio.aws.cloudfront.model.CustomOriginConfig.wrap(buildAwsValue())
}
object CustomOriginConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CustomOriginConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CustomOriginConfig =
      zio.aws.cloudfront.model.CustomOriginConfig(
        httpPort,
        httpsPort,
        originProtocolPolicy,
        originSslProtocols.map(value => value.asEditable),
        originReadTimeout.map(value => value),
        originKeepaliveTimeout.map(value => value)
      )
    def httpPort: Integer
    def httpsPort: Integer
    def originProtocolPolicy: zio.aws.cloudfront.model.OriginProtocolPolicy
    def originSslProtocols
        : Option[zio.aws.cloudfront.model.OriginSslProtocols.ReadOnly]
    def originReadTimeout: Option[Integer]
    def originKeepaliveTimeout: Option[Integer]
    def getHttpPort: ZIO[Any, Nothing, Integer] = ZIO.succeed(httpPort)
    def getHttpsPort: ZIO[Any, Nothing, Integer] = ZIO.succeed(httpsPort)
    def getOriginProtocolPolicy
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.OriginProtocolPolicy] =
      ZIO.succeed(originProtocolPolicy)
    def getOriginSslProtocols: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginSslProtocols.ReadOnly
    ] = AwsError.unwrapOptionField("originSslProtocols", originSslProtocols)
    def getOriginReadTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("originReadTimeout", originReadTimeout)
    def getOriginKeepaliveTimeout: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("originKeepaliveTimeout", originKeepaliveTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CustomOriginConfig
  ) extends zio.aws.cloudfront.model.CustomOriginConfig.ReadOnly {
    override val httpPort: Integer = impl.httpPort(): Integer
    override val httpsPort: Integer = impl.httpsPort(): Integer
    override val originProtocolPolicy
        : zio.aws.cloudfront.model.OriginProtocolPolicy =
      zio.aws.cloudfront.model.OriginProtocolPolicy
        .wrap(impl.originProtocolPolicy())
    override val originSslProtocols
        : Option[zio.aws.cloudfront.model.OriginSslProtocols.ReadOnly] = scala
      .Option(impl.originSslProtocols())
      .map(value => zio.aws.cloudfront.model.OriginSslProtocols.wrap(value))
    override val originReadTimeout: Option[Integer] =
      scala.Option(impl.originReadTimeout()).map(value => value: Integer)
    override val originKeepaliveTimeout: Option[Integer] =
      scala.Option(impl.originKeepaliveTimeout()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CustomOriginConfig
  ): zio.aws.cloudfront.model.CustomOriginConfig.ReadOnly = new Wrapper(impl)
}
