package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFieldLevelEncryptionConfigResponse(
    fieldLevelEncryption: Option[
      zio.aws.cloudfront.model.FieldLevelEncryption
    ] = None,
    location: Option[String] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse = {
    import CreateFieldLevelEncryptionConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse
      .builder()
      .optionallyWith(fieldLevelEncryption.map(value => value.buildAwsValue()))(
        _.fieldLevelEncryption
      )
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse
      .wrap(buildAwsValue())
}
object CreateFieldLevelEncryptionConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse =
      zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse(
        fieldLevelEncryption.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def fieldLevelEncryption
        : Option[zio.aws.cloudfront.model.FieldLevelEncryption.ReadOnly]
    def location: Option[String]
    def eTag: Option[String]
    def getFieldLevelEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FieldLevelEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("fieldLevelEncryption", fieldLevelEncryption)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse
  ) extends zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse.ReadOnly {
    override val fieldLevelEncryption
        : Option[zio.aws.cloudfront.model.FieldLevelEncryption.ReadOnly] = scala
      .Option(impl.fieldLevelEncryption())
      .map(value => zio.aws.cloudfront.model.FieldLevelEncryption.wrap(value))
    override val location: Option[String] =
      scala.Option(impl.location()).map(value => value: String)
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse
  ): zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse.ReadOnly =
    new Wrapper(impl)
}
