package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class AllowedMethods(
    quantity: Integer,
    items: Iterable[zio.aws.cloudfront.model.Method],
    cachedMethods: Option[zio.aws.cloudfront.model.CachedMethods] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.AllowedMethods = {
    import AllowedMethods.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.AllowedMethods
      .builder()
      .quantity(quantity: java.lang.Integer)
      .itemsWithStrings(items.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(cachedMethods.map(value => value.buildAwsValue()))(
        _.cachedMethods
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.AllowedMethods.ReadOnly =
    zio.aws.cloudfront.model.AllowedMethods.wrap(buildAwsValue())
}
object AllowedMethods {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.AllowedMethods
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.AllowedMethods =
      zio.aws.cloudfront.model.AllowedMethods(
        quantity,
        items,
        cachedMethods.map(value => value.asEditable)
      )
    def quantity: Integer
    def items: List[zio.aws.cloudfront.model.Method]
    def cachedMethods: Option[zio.aws.cloudfront.model.CachedMethods.ReadOnly]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, Nothing, List[zio.aws.cloudfront.model.Method]] =
      ZIO.succeed(items)
    def getCachedMethods
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.CachedMethods.ReadOnly] =
      AwsError.unwrapOptionField("cachedMethods", cachedMethods)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.AllowedMethods
  ) extends zio.aws.cloudfront.model.AllowedMethods.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items: List[zio.aws.cloudfront.model.Method] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.cloudfront.model.Method.wrap(item)
      }
      .toList
    override val cachedMethods
        : Option[zio.aws.cloudfront.model.CachedMethods.ReadOnly] = scala
      .Option(impl.cachedMethods())
      .map(value => zio.aws.cloudfront.model.CachedMethods.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.AllowedMethods
  ): zio.aws.cloudfront.model.AllowedMethods.ReadOnly = new Wrapper(impl)
}
