package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateResponseHeadersPolicyRequest(
    responseHeadersPolicyConfig: zio.aws.cloudfront.model.ResponseHeadersPolicyConfig,
    id: String,
    ifMatch: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyRequest = {
    import UpdateResponseHeadersPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyRequest
      .builder()
      .responseHeadersPolicyConfig(responseHeadersPolicyConfig.buildAwsValue())
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateResponseHeadersPolicyRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateResponseHeadersPolicyRequest
      .wrap(buildAwsValue())
}
object UpdateResponseHeadersPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.UpdateResponseHeadersPolicyRequest =
      zio.aws.cloudfront.model.UpdateResponseHeadersPolicyRequest(
        responseHeadersPolicyConfig.asEditable,
        id,
        ifMatch.map(value => value)
      )
    def responseHeadersPolicyConfig
        : zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly
    def id: String
    def ifMatch: Option[String]
    def getResponseHeadersPolicyConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly
    ] = ZIO.succeed(responseHeadersPolicyConfig)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyRequest
  ) extends zio.aws.cloudfront.model.UpdateResponseHeadersPolicyRequest.ReadOnly {
    override val responseHeadersPolicyConfig
        : zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly =
      zio.aws.cloudfront.model.ResponseHeadersPolicyConfig
        .wrap(impl.responseHeadersPolicyConfig())
    override val id: String = impl.id(): String
    override val ifMatch: Option[String] =
      scala.Option(impl.ifMatch()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyRequest
  ): zio.aws.cloudfront.model.UpdateResponseHeadersPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
