package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateFunctionResponse(
    functionSummary: Option[zio.aws.cloudfront.model.FunctionSummary] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateFunctionResponse = {
    import UpdateFunctionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateFunctionResponse
      .builder()
      .optionallyWith(functionSummary.map(value => value.buildAwsValue()))(
        _.functionSummary
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.UpdateFunctionResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateFunctionResponse.wrap(buildAwsValue())
}
object UpdateFunctionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateFunctionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateFunctionResponse =
      zio.aws.cloudfront.model.UpdateFunctionResponse(
        functionSummary.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def functionSummary
        : Option[zio.aws.cloudfront.model.FunctionSummary.ReadOnly]
    def eTag: Option[String]
    def getFunctionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FunctionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("functionSummary", functionSummary)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateFunctionResponse
  ) extends zio.aws.cloudfront.model.UpdateFunctionResponse.ReadOnly {
    override val functionSummary
        : Option[zio.aws.cloudfront.model.FunctionSummary.ReadOnly] = scala
      .Option(impl.functionSummary())
      .map(value => zio.aws.cloudfront.model.FunctionSummary.wrap(value))
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateFunctionResponse
  ): zio.aws.cloudfront.model.UpdateFunctionResponse.ReadOnly = new Wrapper(
    impl
  )
}
