package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResponseHeadersPolicySecurityHeadersConfig(
    xssProtection: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyXSSProtection
    ] = None,
    frameOptions: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyFrameOptions
    ] = None,
    referrerPolicy: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyReferrerPolicy
    ] = None,
    contentSecurityPolicy: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyContentSecurityPolicy
    ] = None,
    contentTypeOptions: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyContentTypeOptions
    ] = None,
    strictTransportSecurity: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig = {
    import ResponseHeadersPolicySecurityHeadersConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig
      .builder()
      .optionallyWith(xssProtection.map(value => value.buildAwsValue()))(
        _.xssProtection
      )
      .optionallyWith(frameOptions.map(value => value.buildAwsValue()))(
        _.frameOptions
      )
      .optionallyWith(referrerPolicy.map(value => value.buildAwsValue()))(
        _.referrerPolicy
      )
      .optionallyWith(
        contentSecurityPolicy.map(value => value.buildAwsValue())
      )(_.contentSecurityPolicy)
      .optionallyWith(contentTypeOptions.map(value => value.buildAwsValue()))(
        _.contentTypeOptions
      )
      .optionallyWith(
        strictTransportSecurity.map(value => value.buildAwsValue())
      )(_.strictTransportSecurity)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig.ReadOnly =
    zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig
      .wrap(buildAwsValue())
}
object ResponseHeadersPolicySecurityHeadersConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig =
      zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig(
        xssProtection.map(value => value.asEditable),
        frameOptions.map(value => value.asEditable),
        referrerPolicy.map(value => value.asEditable),
        contentSecurityPolicy.map(value => value.asEditable),
        contentTypeOptions.map(value => value.asEditable),
        strictTransportSecurity.map(value => value.asEditable)
      )
    def xssProtection: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyXSSProtection.ReadOnly
    ]
    def frameOptions: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyFrameOptions.ReadOnly
    ]
    def referrerPolicy: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyReferrerPolicy.ReadOnly
    ]
    def contentSecurityPolicy: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyContentSecurityPolicy.ReadOnly
    ]
    def contentTypeOptions: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyContentTypeOptions.ReadOnly
    ]
    def strictTransportSecurity: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity.ReadOnly
    ]
    def getXssProtection: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicyXSSProtection.ReadOnly
    ] = AwsError.unwrapOptionField("xssProtection", xssProtection)
    def getFrameOptions: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicyFrameOptions.ReadOnly
    ] = AwsError.unwrapOptionField("frameOptions", frameOptions)
    def getReferrerPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicyReferrerPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("referrerPolicy", referrerPolicy)
    def getContentSecurityPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicyContentSecurityPolicy.ReadOnly
    ] =
      AwsError.unwrapOptionField("contentSecurityPolicy", contentSecurityPolicy)
    def getContentTypeOptions: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicyContentTypeOptions.ReadOnly
    ] = AwsError.unwrapOptionField("contentTypeOptions", contentTypeOptions)
    def getStrictTransportSecurity: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity.ReadOnly
    ] = AwsError.unwrapOptionField(
      "strictTransportSecurity",
      strictTransportSecurity
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig
  ) extends zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig.ReadOnly {
    override val xssProtection: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyXSSProtection.ReadOnly
    ] = scala
      .Option(impl.xssProtection())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicyXSSProtection.wrap(value)
      )
    override val frameOptions: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyFrameOptions.ReadOnly
    ] = scala
      .Option(impl.frameOptions())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicyFrameOptions.wrap(value)
      )
    override val referrerPolicy: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyReferrerPolicy.ReadOnly
    ] = scala
      .Option(impl.referrerPolicy())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicyReferrerPolicy.wrap(value)
      )
    override val contentSecurityPolicy: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyContentSecurityPolicy.ReadOnly
    ] = scala
      .Option(impl.contentSecurityPolicy())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicyContentSecurityPolicy
          .wrap(value)
      )
    override val contentTypeOptions: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyContentTypeOptions.ReadOnly
    ] = scala
      .Option(impl.contentTypeOptions())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicyContentTypeOptions
          .wrap(value)
      )
    override val strictTransportSecurity: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity.ReadOnly
    ] = scala
      .Option(impl.strictTransportSecurity())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig
  ): zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig.ReadOnly =
    new Wrapper(impl)
}
