package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class QueryStringNames(
    quantity: Integer,
    items: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.QueryStringNames = {
    import QueryStringNames.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.QueryStringNames
      .builder()
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.QueryStringNames.ReadOnly =
    zio.aws.cloudfront.model.QueryStringNames.wrap(buildAwsValue())
}
object QueryStringNames {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.QueryStringNames
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.QueryStringNames =
      zio.aws.cloudfront.model
        .QueryStringNames(quantity, items.map(value => value))
    def quantity: Integer
    def items: Option[List[String]]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.QueryStringNames
  ) extends zio.aws.cloudfront.model.QueryStringNames.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items: Option[List[String]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.QueryStringNames
  ): zio.aws.cloudfront.model.QueryStringNames.ReadOnly = new Wrapper(impl)
}
