package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDistributionsByWebAclIdResponse(
    distributionList: Option[zio.aws.cloudfront.model.DistributionList] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse = {
    import ListDistributionsByWebAclIdResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse
      .builder()
      .optionallyWith(distributionList.map(value => value.buildAwsValue()))(
        _.distributionList
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionsByWebAclIdResponse.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionsByWebAclIdResponse
      .wrap(buildAwsValue())
}
object ListDistributionsByWebAclIdResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListDistributionsByWebAclIdResponse =
      zio.aws.cloudfront.model.ListDistributionsByWebAclIdResponse(
        distributionList.map(value => value.asEditable)
      )
    def distributionList
        : Option[zio.aws.cloudfront.model.DistributionList.ReadOnly]
    def getDistributionList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.DistributionList.ReadOnly
    ] = AwsError.unwrapOptionField("distributionList", distributionList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse
  ) extends zio.aws.cloudfront.model.ListDistributionsByWebAclIdResponse.ReadOnly {
    override val distributionList
        : Option[zio.aws.cloudfront.model.DistributionList.ReadOnly] = scala
      .Option(impl.distributionList())
      .map(value => zio.aws.cloudfront.model.DistributionList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse
  ): zio.aws.cloudfront.model.ListDistributionsByWebAclIdResponse.ReadOnly =
    new Wrapper(impl)
}
