package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDistributionsByWebAclIdRequest(
    marker: Option[String] = None,
    maxItems: Option[String] = None,
    webACLId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest = {
    import ListDistributionsByWebAclIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .webACLId(webACLId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionsByWebAclIdRequest.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionsByWebAclIdRequest
      .wrap(buildAwsValue())
}
object ListDistributionsByWebAclIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListDistributionsByWebAclIdRequest =
      zio.aws.cloudfront.model.ListDistributionsByWebAclIdRequest(
        marker.map(value => value),
        maxItems.map(value => value),
        webACLId
      )
    def marker: Option[String]
    def maxItems: Option[String]
    def webACLId: String
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getWebACLId: ZIO[Any, Nothing, String] = ZIO.succeed(webACLId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest
  ) extends zio.aws.cloudfront.model.ListDistributionsByWebAclIdRequest.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[String] =
      scala.Option(impl.maxItems()).map(value => value: String)
    override val webACLId: String = impl.webACLId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest
  ): zio.aws.cloudfront.model.ListDistributionsByWebAclIdRequest.ReadOnly =
    new Wrapper(impl)
}
