package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDistributionsByOriginRequestPolicyIdRequest(
    marker: Option[String] = None,
    maxItems: Option[String] = None,
    originRequestPolicyId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest = {
    import ListDistributionsByOriginRequestPolicyIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .originRequestPolicyId(originRequestPolicyId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest
      .wrap(buildAwsValue())
}
object ListDistributionsByOriginRequestPolicyIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest =
      zio.aws.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest(
        marker.map(value => value),
        maxItems.map(value => value),
        originRequestPolicyId
      )
    def marker: Option[String]
    def maxItems: Option[String]
    def originRequestPolicyId: String
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getOriginRequestPolicyId: ZIO[Any, Nothing, String] =
      ZIO.succeed(originRequestPolicyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest
  ) extends zio.aws.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[String] =
      scala.Option(impl.maxItems()).map(value => value: String)
    override val originRequestPolicyId: String =
      impl.originRequestPolicyId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest
  ): zio.aws.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest.ReadOnly =
    new Wrapper(impl)
}
