package zio.aws.cloudfront.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.{
  ListConflictingAliasesMaxItemsInteger,
  AliasString,
  DistributionIdString
}
import scala.jdk.CollectionConverters._
final case class ListConflictingAliasesRequest(
    distributionId: DistributionIdString,
    alias: AliasString,
    marker: Option[String] = None,
    maxItems: Option[ListConflictingAliasesMaxItemsInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesRequest = {
    import ListConflictingAliasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesRequest
      .builder()
      .distributionId(
        DistributionIdString.unwrap(distributionId): java.lang.String
      )
      .alias(AliasString.unwrap(alias): java.lang.String)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxItems.map(value =>
          ListConflictingAliasesMaxItemsInteger.unwrap(value): Integer
        )
      )(_.maxItems)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListConflictingAliasesRequest.ReadOnly =
    zio.aws.cloudfront.model.ListConflictingAliasesRequest.wrap(buildAwsValue())
}
object ListConflictingAliasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListConflictingAliasesRequest =
      zio.aws.cloudfront.model.ListConflictingAliasesRequest(
        distributionId,
        alias,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def distributionId: DistributionIdString
    def alias: AliasString
    def marker: Option[String]
    def maxItems: Option[ListConflictingAliasesMaxItemsInteger]
    def getDistributionId: ZIO[Any, Nothing, DistributionIdString] =
      ZIO.succeed(distributionId)
    def getAlias: ZIO[Any, Nothing, AliasString] = ZIO.succeed(alias)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, ListConflictingAliasesMaxItemsInteger] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesRequest
  ) extends zio.aws.cloudfront.model.ListConflictingAliasesRequest.ReadOnly {
    override val distributionId: DistributionIdString =
      zio.aws.cloudfront.model.primitives
        .DistributionIdString(impl.distributionId())
    override val alias: AliasString =
      zio.aws.cloudfront.model.primitives.AliasString(impl.alias())
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[ListConflictingAliasesMaxItemsInteger] = scala
      .Option(impl.maxItems())
      .map(value =>
        zio.aws.cloudfront.model.primitives
          .ListConflictingAliasesMaxItemsInteger(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesRequest
  ): zio.aws.cloudfront.model.ListConflictingAliasesRequest.ReadOnly =
    new Wrapper(impl)
}
