package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KGKeyPairIds(
    keyGroupId: Option[String] = None,
    keyPairIds: Option[zio.aws.cloudfront.model.KeyPairIds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.KGKeyPairIds = {
    import KGKeyPairIds.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.KGKeyPairIds
      .builder()
      .optionallyWith(keyGroupId.map(value => value: java.lang.String))(
        _.keyGroupId
      )
      .optionallyWith(keyPairIds.map(value => value.buildAwsValue()))(
        _.keyPairIds
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.KGKeyPairIds.ReadOnly =
    zio.aws.cloudfront.model.KGKeyPairIds.wrap(buildAwsValue())
}
object KGKeyPairIds {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.KGKeyPairIds
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.KGKeyPairIds =
      zio.aws.cloudfront.model.KGKeyPairIds(
        keyGroupId.map(value => value),
        keyPairIds.map(value => value.asEditable)
      )
    def keyGroupId: Option[String]
    def keyPairIds: Option[zio.aws.cloudfront.model.KeyPairIds.ReadOnly]
    def getKeyGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyGroupId", keyGroupId)
    def getKeyPairIds
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.KeyPairIds.ReadOnly] =
      AwsError.unwrapOptionField("keyPairIds", keyPairIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.KGKeyPairIds
  ) extends zio.aws.cloudfront.model.KGKeyPairIds.ReadOnly {
    override val keyGroupId: Option[String] =
      scala.Option(impl.keyGroupId()).map(value => value: String)
    override val keyPairIds
        : Option[zio.aws.cloudfront.model.KeyPairIds.ReadOnly] = scala
      .Option(impl.keyPairIds())
      .map(value => zio.aws.cloudfront.model.KeyPairIds.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.KGKeyPairIds
  ): zio.aws.cloudfront.model.KGKeyPairIds.ReadOnly = new Wrapper(impl)
}
