package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteFieldLevelEncryptionProfileRequest(
    id: String,
    ifMatch: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest = {
    import DeleteFieldLevelEncryptionProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest.ReadOnly =
    zio.aws.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest
      .wrap(buildAwsValue())
}
object DeleteFieldLevelEncryptionProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest =
      zio.aws.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest(
        id,
        ifMatch.map(value => value)
      )
    def id: String
    def ifMatch: Option[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest
  ) extends zio.aws.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val ifMatch: Option[String] =
      scala.Option(impl.ifMatch()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest
  ): zio.aws.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest.ReadOnly =
    new Wrapper(impl)
}
