package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class CustomHeaders(
    quantity: Integer,
    items: Option[Iterable[zio.aws.cloudfront.model.OriginCustomHeader]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CustomHeaders = {
    import CustomHeaders.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CustomHeaders
      .builder()
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CustomHeaders.ReadOnly =
    zio.aws.cloudfront.model.CustomHeaders.wrap(buildAwsValue())
}
object CustomHeaders {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CustomHeaders
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CustomHeaders =
      zio.aws.cloudfront.model.CustomHeaders(
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def quantity: Integer
    def items
        : Option[List[zio.aws.cloudfront.model.OriginCustomHeader.ReadOnly]]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.OriginCustomHeader.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CustomHeaders
  ) extends zio.aws.cloudfront.model.CustomHeaders.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items
        : Option[List[zio.aws.cloudfront.model.OriginCustomHeader.ReadOnly]] =
      scala
        .Option(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.OriginCustomHeader.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CustomHeaders
  ): zio.aws.cloudfront.model.CustomHeaders.ReadOnly = new Wrapper(impl)
}
