package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CachePolicy(
    id: String,
    lastModifiedTime: Timestamp,
    cachePolicyConfig: zio.aws.cloudfront.model.CachePolicyConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CachePolicy = {
    import CachePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CachePolicy
      .builder()
      .id(id: java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .cachePolicyConfig(cachePolicyConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CachePolicy.ReadOnly =
    zio.aws.cloudfront.model.CachePolicy.wrap(buildAwsValue())
}
object CachePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CachePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CachePolicy =
      zio.aws.cloudfront.model
        .CachePolicy(id, lastModifiedTime, cachePolicyConfig.asEditable)
    def id: String
    def lastModifiedTime: Timestamp
    def cachePolicyConfig: zio.aws.cloudfront.model.CachePolicyConfig.ReadOnly
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getCachePolicyConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.CachePolicyConfig.ReadOnly
    ] = ZIO.succeed(cachePolicyConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CachePolicy
  ) extends zio.aws.cloudfront.model.CachePolicy.ReadOnly {
    override val id: String = impl.id(): String
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val cachePolicyConfig
        : zio.aws.cloudfront.model.CachePolicyConfig.ReadOnly =
      zio.aws.cloudfront.model.CachePolicyConfig.wrap(impl.cachePolicyConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CachePolicy
  ): zio.aws.cloudfront.model.CachePolicy.ReadOnly = new Wrapper(impl)
}
