package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListInvalidationsRequest(
    distributionId: String,
    marker: Option[String] = None,
    maxItems: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest = {
    import ListInvalidationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest
      .builder()
      .distributionId(distributionId: java.lang.String)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListInvalidationsRequest.ReadOnly =
    zio.aws.cloudfront.model.ListInvalidationsRequest.wrap(buildAwsValue())
}
object ListInvalidationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListInvalidationsRequest =
      zio.aws.cloudfront.model.ListInvalidationsRequest(
        distributionId,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def distributionId: String
    def marker: Option[String]
    def maxItems: Option[String]
    def getDistributionId: ZIO[Any, Nothing, String] =
      ZIO.succeed(distributionId)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest
  ) extends zio.aws.cloudfront.model.ListInvalidationsRequest.ReadOnly {
    override val distributionId: String = impl.distributionId(): String
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[String] =
      scala.Option(impl.maxItems()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest
  ): zio.aws.cloudfront.model.ListInvalidationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
