package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateKeyGroupRequest(
    keyGroupConfig: zio.aws.cloudfront.model.KeyGroupConfig,
    id: String,
    ifMatch: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupRequest = {
    import UpdateKeyGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupRequest
      .builder()
      .keyGroupConfig(keyGroupConfig.buildAwsValue())
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.UpdateKeyGroupRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateKeyGroupRequest.wrap(buildAwsValue())
}
object UpdateKeyGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateKeyGroupRequest =
      zio.aws.cloudfront.model.UpdateKeyGroupRequest(
        keyGroupConfig.asEditable,
        id,
        ifMatch.map(value => value)
      )
    def keyGroupConfig: zio.aws.cloudfront.model.KeyGroupConfig.ReadOnly
    def id: String
    def ifMatch: Option[String]
    def getKeyGroupConfig
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.KeyGroupConfig.ReadOnly] =
      ZIO.succeed(keyGroupConfig)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupRequest
  ) extends zio.aws.cloudfront.model.UpdateKeyGroupRequest.ReadOnly {
    override val keyGroupConfig
        : zio.aws.cloudfront.model.KeyGroupConfig.ReadOnly =
      zio.aws.cloudfront.model.KeyGroupConfig.wrap(impl.keyGroupConfig())
    override val id: String = impl.id(): String
    override val ifMatch: Option[String] =
      scala.Option(impl.ifMatch()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupRequest
  ): zio.aws.cloudfront.model.UpdateKeyGroupRequest.ReadOnly = new Wrapper(impl)
}
