package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateFieldLevelEncryptionConfigResponse(
    fieldLevelEncryption: Option[
      zio.aws.cloudfront.model.FieldLevelEncryption
    ] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse = {
    import UpdateFieldLevelEncryptionConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse
      .builder()
      .optionallyWith(fieldLevelEncryption.map(value => value.buildAwsValue()))(
        _.fieldLevelEncryption
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse
      .wrap(buildAwsValue())
}
object UpdateFieldLevelEncryptionConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse =
      zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse(
        fieldLevelEncryption.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def fieldLevelEncryption
        : Option[zio.aws.cloudfront.model.FieldLevelEncryption.ReadOnly]
    def eTag: Option[String]
    def getFieldLevelEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FieldLevelEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("fieldLevelEncryption", fieldLevelEncryption)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse
  ) extends zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse.ReadOnly {
    override val fieldLevelEncryption
        : Option[zio.aws.cloudfront.model.FieldLevelEncryption.ReadOnly] = scala
      .Option(impl.fieldLevelEncryption())
      .map(value => zio.aws.cloudfront.model.FieldLevelEncryption.wrap(value))
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse
  ): zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse.ReadOnly =
    new Wrapper(impl)
}
