package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListRealtimeLogConfigsResponse(
    realtimeLogConfigs: Option[zio.aws.cloudfront.model.RealtimeLogConfigs] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsResponse = {
    import ListRealtimeLogConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsResponse
      .builder()
      .optionallyWith(realtimeLogConfigs.map(value => value.buildAwsValue()))(
        _.realtimeLogConfigs
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListRealtimeLogConfigsResponse.ReadOnly =
    zio.aws.cloudfront.model.ListRealtimeLogConfigsResponse
      .wrap(buildAwsValue())
}
object ListRealtimeLogConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListRealtimeLogConfigsResponse =
      zio.aws.cloudfront.model.ListRealtimeLogConfigsResponse(
        realtimeLogConfigs.map(value => value.asEditable)
      )
    def realtimeLogConfigs
        : Option[zio.aws.cloudfront.model.RealtimeLogConfigs.ReadOnly]
    def getRealtimeLogConfigs: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.RealtimeLogConfigs.ReadOnly
    ] = AwsError.unwrapOptionField("realtimeLogConfigs", realtimeLogConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsResponse
  ) extends zio.aws.cloudfront.model.ListRealtimeLogConfigsResponse.ReadOnly {
    override val realtimeLogConfigs
        : Option[zio.aws.cloudfront.model.RealtimeLogConfigs.ReadOnly] = scala
      .Option(impl.realtimeLogConfigs())
      .map(value => zio.aws.cloudfront.model.RealtimeLogConfigs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsResponse
  ): zio.aws.cloudfront.model.ListRealtimeLogConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
