package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteCloudFrontOriginAccessIdentityRequest(
    id: String,
    ifMatch: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest = {
    import DeleteCloudFrontOriginAccessIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest.ReadOnly =
    zio.aws.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest
      .wrap(buildAwsValue())
}
object DeleteCloudFrontOriginAccessIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest =
      zio.aws.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest(
        id,
        ifMatch.map(value => value)
      )
    def id: String
    def ifMatch: Option[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest
  ) extends zio.aws.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val ifMatch: Option[String] =
      scala.Option(impl.ifMatch()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest
  ): zio.aws.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest.ReadOnly =
    new Wrapper(impl)
}
