package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class ActiveTrustedKeyGroups(
    enabled: Boolean,
    quantity: Integer,
    items: Option[Iterable[zio.aws.cloudfront.model.KGKeyPairIds]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ActiveTrustedKeyGroups = {
    import ActiveTrustedKeyGroups.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ActiveTrustedKeyGroups
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ActiveTrustedKeyGroups.ReadOnly =
    zio.aws.cloudfront.model.ActiveTrustedKeyGroups.wrap(buildAwsValue())
}
object ActiveTrustedKeyGroups {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ActiveTrustedKeyGroups
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ActiveTrustedKeyGroups =
      zio.aws.cloudfront.model.ActiveTrustedKeyGroups(
        enabled,
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def enabled: Boolean
    def quantity: Integer
    def items: Option[List[zio.aws.cloudfront.model.KGKeyPairIds.ReadOnly]]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.KGKeyPairIds.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ActiveTrustedKeyGroups
  ) extends zio.aws.cloudfront.model.ActiveTrustedKeyGroups.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val quantity: Integer = impl.quantity(): Integer
    override val items
        : Option[List[zio.aws.cloudfront.model.KGKeyPairIds.ReadOnly]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.KGKeyPairIds.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ActiveTrustedKeyGroups
  ): zio.aws.cloudfront.model.ActiveTrustedKeyGroups.ReadOnly = new Wrapper(
    impl
  )
}
