package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetStreamingDistributionConfigResponse(
    streamingDistributionConfig: Option[
      zio.aws.cloudfront.model.StreamingDistributionConfig
    ] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse = {
    import GetStreamingDistributionConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse
      .builder()
      .optionallyWith(
        streamingDistributionConfig.map(value => value.buildAwsValue())
      )(_.streamingDistributionConfig)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetStreamingDistributionConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.GetStreamingDistributionConfigResponse
      .wrap(buildAwsValue())
}
object GetStreamingDistributionConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetStreamingDistributionConfigResponse =
      zio.aws.cloudfront.model.GetStreamingDistributionConfigResponse(
        streamingDistributionConfig.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def streamingDistributionConfig
        : Option[zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly]
    def eTag: Option[String]
    def getStreamingDistributionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "streamingDistributionConfig",
      streamingDistributionConfig
    )
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse
  ) extends zio.aws.cloudfront.model.GetStreamingDistributionConfigResponse.ReadOnly {
    override val streamingDistributionConfig: Option[
      zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly
    ] = scala
      .Option(impl.streamingDistributionConfig())
      .map(value =>
        zio.aws.cloudfront.model.StreamingDistributionConfig.wrap(value)
      )
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse
  ): zio.aws.cloudfront.model.GetStreamingDistributionConfigResponse.ReadOnly =
    new Wrapper(impl)
}
