package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateOriginRequestPolicyResponse(
    originRequestPolicy: Option[zio.aws.cloudfront.model.OriginRequestPolicy] =
      None,
    location: Option[String] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse = {
    import CreateOriginRequestPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse
      .builder()
      .optionallyWith(originRequestPolicy.map(value => value.buildAwsValue()))(
        _.originRequestPolicy
      )
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse
      .wrap(buildAwsValue())
}
object CreateOriginRequestPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse =
      zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse(
        originRequestPolicy.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def originRequestPolicy
        : Option[zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly]
    def location: Option[String]
    def eTag: Option[String]
    def getOriginRequestPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("originRequestPolicy", originRequestPolicy)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse
  ) extends zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse.ReadOnly {
    override val originRequestPolicy
        : Option[zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly] = scala
      .Option(impl.originRequestPolicy())
      .map(value => zio.aws.cloudfront.model.OriginRequestPolicy.wrap(value))
    override val location: Option[String] =
      scala.Option(impl.location()).map(value => value: String)
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse
  ): zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
