package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateOriginRequestPolicyRequest(
    originRequestPolicyConfig: zio.aws.cloudfront.model.OriginRequestPolicyConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyRequest = {
    import CreateOriginRequestPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyRequest
      .builder()
      .originRequestPolicyConfig(originRequestPolicyConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateOriginRequestPolicyRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateOriginRequestPolicyRequest
      .wrap(buildAwsValue())
}
object CreateOriginRequestPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateOriginRequestPolicyRequest =
      zio.aws.cloudfront.model
        .CreateOriginRequestPolicyRequest(originRequestPolicyConfig.asEditable)
    def originRequestPolicyConfig
        : zio.aws.cloudfront.model.OriginRequestPolicyConfig.ReadOnly
    def getOriginRequestPolicyConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginRequestPolicyConfig.ReadOnly
    ] = ZIO.succeed(originRequestPolicyConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyRequest
  ) extends zio.aws.cloudfront.model.CreateOriginRequestPolicyRequest.ReadOnly {
    override val originRequestPolicyConfig
        : zio.aws.cloudfront.model.OriginRequestPolicyConfig.ReadOnly =
      zio.aws.cloudfront.model.OriginRequestPolicyConfig
        .wrap(impl.originRequestPolicyConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyRequest
  ): zio.aws.cloudfront.model.CreateOriginRequestPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
