package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateMonitoringSubscriptionRequest(
    distributionId: String,
    monitoringSubscription: zio.aws.cloudfront.model.MonitoringSubscription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionRequest = {
    import CreateMonitoringSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionRequest
      .builder()
      .distributionId(distributionId: java.lang.String)
      .monitoringSubscription(monitoringSubscription.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateMonitoringSubscriptionRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateMonitoringSubscriptionRequest
      .wrap(buildAwsValue())
}
object CreateMonitoringSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CreateMonitoringSubscriptionRequest =
      zio.aws.cloudfront.model.CreateMonitoringSubscriptionRequest(
        distributionId,
        monitoringSubscription.asEditable
      )
    def distributionId: String
    def monitoringSubscription
        : zio.aws.cloudfront.model.MonitoringSubscription.ReadOnly
    def getDistributionId: ZIO[Any, Nothing, String] =
      ZIO.succeed(distributionId)
    def getMonitoringSubscription: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.MonitoringSubscription.ReadOnly
    ] = ZIO.succeed(monitoringSubscription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionRequest
  ) extends zio.aws.cloudfront.model.CreateMonitoringSubscriptionRequest.ReadOnly {
    override val distributionId: String = impl.distributionId(): String
    override val monitoringSubscription
        : zio.aws.cloudfront.model.MonitoringSubscription.ReadOnly =
      zio.aws.cloudfront.model.MonitoringSubscription
        .wrap(impl.monitoringSubscription())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionRequest
  ): zio.aws.cloudfront.model.CreateMonitoringSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
