package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class ResponseHeadersPolicyCustomHeadersConfig(
    quantity: Integer,
    items: Option[
      Iterable[zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeader]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig = {
    import ResponseHeadersPolicyCustomHeadersConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig
      .builder()
      .quantity(Integer.unwrap(quantity): java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig.ReadOnly =
    zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig
      .wrap(buildAwsValue())
}
object ResponseHeadersPolicyCustomHeadersConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig =
      zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig(
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def quantity: Integer
    def items: Option[
      List[zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeader.ReadOnly]
    ]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeader.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig
  ) extends zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig.ReadOnly {
    override val quantity: Integer =
      zio.aws.cloudfront.model.primitives.Integer(impl.quantity())
    override val items: Option[
      List[zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeader.ReadOnly]
    ] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeader.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig
  ): zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig.ReadOnly =
    new Wrapper(impl)
}
