package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class ResponseHeadersPolicyCorsConfig(
    accessControlAllowOrigins: zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins,
    accessControlAllowHeaders: zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders,
    accessControlAllowMethods: zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods,
    accessControlAllowCredentials: Boolean,
    accessControlExposeHeaders: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders
    ] = None,
    accessControlMaxAgeSec: Option[Integer] = None,
    originOverride: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyCorsConfig = {
    import ResponseHeadersPolicyCorsConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyCorsConfig
      .builder()
      .accessControlAllowOrigins(accessControlAllowOrigins.buildAwsValue())
      .accessControlAllowHeaders(accessControlAllowHeaders.buildAwsValue())
      .accessControlAllowMethods(accessControlAllowMethods.buildAwsValue())
      .accessControlAllowCredentials(
        accessControlAllowCredentials: java.lang.Boolean
      )
      .optionallyWith(
        accessControlExposeHeaders.map(value => value.buildAwsValue())
      )(_.accessControlExposeHeaders)
      .optionallyWith(
        accessControlMaxAgeSec.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.accessControlMaxAgeSec)
      .originOverride(originOverride: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig.ReadOnly =
    zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig
      .wrap(buildAwsValue())
}
object ResponseHeadersPolicyCorsConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyCorsConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig =
      zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig(
        accessControlAllowOrigins.asEditable,
        accessControlAllowHeaders.asEditable,
        accessControlAllowMethods.asEditable,
        accessControlAllowCredentials,
        accessControlExposeHeaders.map(value => value.asEditable),
        accessControlMaxAgeSec.map(value => value),
        originOverride
      )
    def accessControlAllowOrigins
        : zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins.ReadOnly
    def accessControlAllowHeaders
        : zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders.ReadOnly
    def accessControlAllowMethods
        : zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods.ReadOnly
    def accessControlAllowCredentials: Boolean
    def accessControlExposeHeaders: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders.ReadOnly
    ]
    def accessControlMaxAgeSec: Option[Integer]
    def originOverride: Boolean
    def getAccessControlAllowOrigins: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins.ReadOnly
    ] = ZIO.succeed(accessControlAllowOrigins)
    def getAccessControlAllowHeaders: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders.ReadOnly
    ] = ZIO.succeed(accessControlAllowHeaders)
    def getAccessControlAllowMethods: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods.ReadOnly
    ] = ZIO.succeed(accessControlAllowMethods)
    def getAccessControlAllowCredentials: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(accessControlAllowCredentials)
    def getAccessControlExposeHeaders: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accessControlExposeHeaders",
      accessControlExposeHeaders
    )
    def getAccessControlMaxAgeSec: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("accessControlMaxAgeSec", accessControlMaxAgeSec)
    def getOriginOverride: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(originOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyCorsConfig
  ) extends zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig.ReadOnly {
    override val accessControlAllowOrigins
        : zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins.ReadOnly =
      zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins
        .wrap(impl.accessControlAllowOrigins())
    override val accessControlAllowHeaders
        : zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders.ReadOnly =
      zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders
        .wrap(impl.accessControlAllowHeaders())
    override val accessControlAllowMethods
        : zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods.ReadOnly =
      zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods
        .wrap(impl.accessControlAllowMethods())
    override val accessControlAllowCredentials: Boolean =
      impl.accessControlAllowCredentials(): Boolean
    override val accessControlExposeHeaders: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders.ReadOnly
    ] = scala
      .Option(impl.accessControlExposeHeaders())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders
          .wrap(value)
      )
    override val accessControlMaxAgeSec: Option[Integer] = scala
      .Option(impl.accessControlMaxAgeSec())
      .map(value => zio.aws.cloudfront.model.primitives.Integer(value))
    override val originOverride: Boolean = impl.originOverride(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyCorsConfig
  ): zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig.ReadOnly =
    new Wrapper(impl)
}
